//
//  lcd_gui_manage.h	  Part of GUI support library, Figure data manager
//  Copyright(C)2014 Toyohiko Togashi tog001@nifty.com
//
//
//  This program is free software; you can redistribute it and/or modify it under the terms of the
//  GNU General Public License as published by the Free Software Foundation; either version 3
//  of the License, or (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
//  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//  See the GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License along with this program.
//  If not, see <http://www.gnu.org/licenses/>
//
//
//    Update history
//    ---------- ----- -------------------------------------------
//    2014.02.15 v0.0  First cording
//    2014.03.15 v0.2  Commit
//

#ifndef LCD_GUI_FIGURE_MANAGE_H_
#define LCD_GUI_FIGURE_MANAGE_H_

#include "lcd_gui_figure.h"

//
//	etc
//
struct lcd_guiGlobalFlags {
	unsigned int	dirty:		1;
	unsigned int	reserve:	15;
};
extern struct lcd_guiGlobalFlags	lcd_guiGlobalFlags;

//
//	API
//
extern void						lcd_guiSetRelink(struct lcd_gui *seg);
extern void						lcd_guiSetDirty(struct lcd_gui *seg);
extern void						lcd_guiSetHidden(struct lcd_gui *seg, int f);
#define							lcd_guiSetDirtys(seg)		lcd_guiSetDirty((struct lcd_gui *)seg)
#define							lcd_guiSetHiddens(seg,f)	lcd_guiSetHidden((struct lcd_gui *)seg, f)
extern struct lcd_guiGroup		*lcd_guiGetGroupParent(struct lcd_gui *seg);
extern struct lcd_guiGroup		*lcd_guiFindGroupByPoint(struct lcd_gui *root, struct lcd_guiCoordinate *point);
extern void						lcd_guiSet7segFixedPoint(struct lcd_gui7seg *seg, int value, int dotPoint);
#define							lcd_guiGetParent(seg)		lcd_guiGetGroupParent((struct lcd_gui *)seg)
extern void						lcd_guiDebugDump(struct lcd_gui *s);

#endif /* LCD_GUI_FIGURE_MANAGE_H_ */
