//
//  ViewController.m
//  ALD
//
//  Created by 富樫 豊彦 on 2017/02/12.
//  Copyright © 2017年 富樫 豊彦. All rights reserved.
//

#import "ViewController.h"
#import <CoreBluetooth/CoreBluetooth.h>

@interface ViewController () <CBCentralManagerDelegate, CBPeripheralDelegate>
@property (strong, nonatomic) CBCentralManager      *centralManager;
@property (strong, nonatomic) CBPeripheral          *discoveredPeripheral;
@property (strong, nonatomic) CBCharacteristic      *alartLevel;
@end

@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view, typically from a nib.
    NSLog(@"BT Init");
    self.centralManager = [[CBCentralManager alloc] initWithDelegate:self queue:nil];
    [self.openSw setEnabled:NO];
}


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}


#pragma mark - Bluetooth-LE central


- (void)centralManagerDidUpdateState:(CBCentralManager *)central {
    NSLog(@"BT update %ld", (long)central.state);
    if (central.state != CBCentralManagerStatePoweredOn) {
        return;
    }
    [self scan];
}


- (void)scan
{
    [self.centralManager scanForPeripheralsWithServices:@[[CBUUID UUIDWithString:ALD_SERVICE_UUID]] options:nil];
    NSLog(@"Scanning...");
}


- (void)centralManager:(CBCentralManager *)central didDiscoverPeripheral:(CBPeripheral *)peripheral advertisementData:(NSDictionary *)advertisementData RSSI:(NSNumber *)RSSI
{
    NSLog(@"Discovered %@ at %@db", peripheral.name, RSSI);
    [self.msg setText:[[NSString alloc] initWithFormat:@"%@ at %@[db]", peripheral.name, RSSI]];
    if (self.discoveredPeripheral != peripheral) {
        self.discoveredPeripheral = peripheral;
        NSLog(@"Connecting to peripheral %@", peripheral);
        [self.centralManager connectPeripheral:peripheral options:nil];
    }
}


- (void)centralManager:(CBCentralManager *)central didFailToConnectPeripheral:(CBPeripheral *)peripheral error:(NSError *)error
{
    NSLog(@"Failed to connect to %@. (%@)", peripheral, [error localizedDescription]);
    [self cleanup];
}


- (void)centralManager:(CBCentralManager *)central didConnectPeripheral:(CBPeripheral *)peripheral
{
    NSLog(@"Peripheral Connected %@", peripheral);
    [self.msg setText:[[NSString alloc] initWithFormat:@"Connected %@", peripheral.name]];
    [self.centralManager stopScan];
    peripheral.delegate = self;
    [peripheral discoverServices:@[[CBUUID UUIDWithString:ALD_SERVICE_UUID]]];
}


- (void)peripheral:(CBPeripheral *)peripheral didDiscoverServices:(NSError *)error
{
    if (error) {
        NSLog(@"Error discovering services: %@", [error localizedDescription]);
        [self cleanup];
        return;
    }
    for (CBService *service in peripheral.services) {
        [peripheral discoverCharacteristics:@[[CBUUID UUIDWithString:ALD_CHARACTERISTIC_UUID1]] forService:service];
    }
}


- (void)peripheral:(CBPeripheral *)peripheral didDiscoverCharacteristicsForService:(CBService *)service error:(NSError *)error
{
    if (error) {
        NSLog(@"Error discovering characteristics: %@", [error localizedDescription]);
        [self cleanup];
        return;
    }
    for (CBCharacteristic *characteristic in service.characteristics) {
        NSLog(@"Char=%@", characteristic.UUID);
        if ([characteristic.UUID isEqual:[CBUUID UUIDWithString:ALD_CHARACTERISTIC_UUID1]]) {
            unsigned char   buff[1];
            
            self.alartLevel = characteristic;
            buff[0] = 0;
            NSData *val = [[NSData alloc] initWithBytes:&buff length:sizeof(buff)];
            [peripheral writeValue:val forCharacteristic:characteristic type:CBCharacteristicWriteWithResponse];
            [self.openSw setEnabled:YES];
        }
    }
}


- (void)peripheral:(CBPeripheral *)peripheral didUpdateValueForCharacteristic:(CBCharacteristic *)characteristic error:(NSError *)error
{
    if (error) {
        NSLog(@"Error discovering characteristics: %@", [error localizedDescription]);
        return;
    }
    if ([characteristic.UUID isEqual:[CBUUID UUIDWithString:ALD_CHARACTERISTIC_UUID1]]) {
        NSLog(@"Updated: %@", characteristic.UUID);
    }
}


- (void)centralManager:(CBCentralManager *)central didDisconnectPeripheral:(CBPeripheral *)peripheral error:(NSError *)error
{
    NSLog(@"Peripheral Disconnected");
    self.discoveredPeripheral = nil;
    [self scan];
    [self.openSw setEnabled:NO];
    [self.msg setText:@"Waiting a reconnect..."];
}

- (void)cleanup {
    NSLog(@"BT Cleanup");
    return;
}

- (IBAction)slidedOpenSw:(id)sender{
    NSLog(@"slidedOpenSw");
    if (self.alartLevel) {
        unsigned char   buff[1];

        if (self.openSw.on) {
            buff[0] = 0;
        } else {
            buff[0] = 1;
        }
        NSData *val = [[NSData alloc] initWithBytes:&buff length:sizeof(buff)];
        [self.discoveredPeripheral writeValue:val forCharacteristic:self.alartLevel type:CBCharacteristicWriteWithResponse];
    }
}


@end
